
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   GENTYPES.H - General Type Definitions
// 
//
//   DESCRIPTION
//
//   Short-hand type definitions for commonly used data types.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\GENTYPES.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:08   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.3   Jul 09 1997 10:25:30   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:04:38   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:12:18   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:24   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#ifndef GENTYPES_H
#define GENTYPES_H

#define FAR       far

/*
// ---- Aliases for common "C" types
// ----   (AAMP2/AAMP28 dependent)
*/

/* Signed types             AAMP2 representation: */

typedef char    tCHAR;			/* 16-bit signed character */
typedef short   tSHORT;			/* 16-bit signed integer */
typedef int     tINT;			/* 16-bit signed integer */
typedef long    tLONG;			/* 32-bit signed integer */
typedef float   tFLOAT;			/* 32-bit floating point */
typedef double  tDOUBLE;		/* 48-bit extended floating point */

typedef unsigned char tUCHAR;		/* Unsigned types */
typedef unsigned short tUSHORT;
typedef unsigned int tUINT;
typedef unsigned long tULONG;

typedef volatile tCHAR tHCHAR;		/* volatile Unsigned types */
typedef volatile tSHORT tHSHORT;
typedef volatile tINT tHINT;
typedef volatile tLONG tHLONG;
typedef volatile tFLOAT tHFLOAT;
typedef volatile tDOUBLE tHDOUBLE;

typedef volatile tUCHAR tHUCHAR;	/* volatile Unsigned types */
typedef volatile tUSHORT tHUSHORT;
typedef volatile tUINT tHUINT;
typedef volatile tULONG tHULONG;

typedef volatile const tSHORT tHRESERVED;  /* volatile reserved type */

typedef void    tVOID;			/* Void Type */

typedef tUSHORT tBOOL;			/* Derived boolean type */
#define FALSE ((tBOOL) 0)
#define TRUE  ((tBOOL) 1)

typedef struct {			/* 48bit fixed point type */
  tUSHORT  Frac;
  tULONG   Int;     
}               tRIPLE;

typedef struct {                        /* 48-bit unsigned integer type */
  tUSHORT data[3];
}               tUTRIPLE;

typedef struct {                        /* 48-bit signed integer type */
  tUSHORT data[2];
  tSHORT  data_2;
}               tTRIPLE;

  // generic definition for the special Unsigned Tripple Integer (UTI) 
  // type.  Allows data to be viewed in 3 different manners.
  //
  typedef union {
    tUTRIPLE  ThreeShorts;
    tRIPLE    ShortLong;
    struct {
      tULONG  LongWord;
      tUSHORT ShortWord;
    } LongShort;
    
    #ifdef aamp2
       tDOUBLE   Triple;    /* on the AAMP tDOUBLE is three words; allows simple assignment */
    #endif

  } tTRIPLEFLX;

typedef union {     /* a long with upper and lower words accessable as short */
  tLONG     l;
  tSHORT    w[2];
}        tLW; 
                 
typedef tUSHORT tCHANMASK;                  
                 
#endif
